(*|  9:23  9/09/1996 *)
PROGRAM STAMP;

USES Crt,Dos;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];
  MaxString= STRING[255];

VAR
  ChosenDrive,ThisFileName,FileExt: FNameType;
  FindRec: SearchRec;
  ByteFile: FILE OF Byte;
  FileSpec,OptionString,OriginalPath,CurrentPath,TextLine: LineString;
  Prefix,Suffix,StampLine: LineString;
  I,DriveNum: Integer;
  Abort: Boolean;
  C:Char;

FUNCTION IntToString(Num, Width : Integer) : LineString;
{ Changes an integer into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width, TempString);
  IntToString := TempString;
END; { IntToString }

FUNCTION IntToPadString(Num, Width : Integer) : LineString;
{ Changes an integer into a string and pads it with a zero on the left if
  it is less than 10 }
BEGIN
  IF Num < 10 THEN
    IntToPadString := '0' + IntToString(Num, Width)
  ELSE
    IntToPadString := IntToString(Num, Width);
END; { IntToString }

FUNCTION RealToString(Num : Real; Width, Places : Integer) : LineString;
{ Changes a real number into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width:Places, TempString);
  RealToString := TempString;
END; { RealToString }

{ ==================== GENERAL PURPOSE STRING ROUTINES ====================== }
FUNCTION FixString(FString : LineString; Len : Byte) : LineString;
{ Makes a string a specified length.  If the string is too long, the extra
  characters will be truncated.  If the string is too short, the string will
  be padded with spaces.
}
var StringLen : byte absolute FString;
                            { Make a variable for FString's length byte }
BEGIN
  IF StringLen > Len THEN
    Delete(FString, Succ(Len), StringLen - Len)
                                    { Delete end of string if it is too long }
  ELSE
    WHILE StringLen < Len DO          { Pad FString with spaces on the right }
      FString := FString + ' ';
  FixString := FString;
END; { FixString }

FUNCTION UpperCase(S : LineString) : LineString;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

FUNCTION FileDateString(Date :DateTime):LineString;
BEGIN
  WITH Date DO
    FileDateString:=IntToString(Day,2) + '/' +
                    IntToPadString(Month,1) + '/' +
                    IntToString(Year,4);
END;

FUNCTION FileTimeString(Time :DateTime):LineString;
BEGIN
  WITH Time DO
    FileTimeString:=IntToString(Hour,2) + ':' +
                    IntToPadString(Min,1);
END;

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : STAMP [D:][filespec] [prefix] [suffix]');
  Writeln('           Default filespec *.PAS');
  Writeln('           Prefix set automatically for .C, .CPP and .ASM files');
(*  Writeln('Switches : /P    Copy');*)
  HALT;
END;  { ShowHelp }

PROCEDURE ProcessOptions;
BEGIN
END; { ProcessOptions }

PROCEDURE AddStamp(FName:FNameType);

VAR
  SrcFile,DestFile: TEXT;
  DFName: FNameType;
  FileTime: LongInt;
  CopyLine: MaxString;
BEGIN
  DFName:=COPY(FName,1,POS('.',FName))+'$$$';
  Writeln(' Adding Stamp');
  Assign(SrcFile,FName);
  Reset(SrcFile);
  GetFTime(SrcFile,FileTime);
  Assign(DestFile,DFName);
  Rewrite(DestFile);
  StampLine:=Prefix + StampLine + Suffix;
  Writeln(DestFile,StampLine);
  WHILE NOT EOF(SrcFile) DO BEGIN
    Readln(SrcFile,CopyLine);
    Writeln(DestFile,CopyLine);
  END;
  Close(SrcFile);
  {$I-}
  Close(DestFile);
  {$I+}
  IF IOResult = 0 THEN
    BEGIN
      Reset(DestFile);
      SetFTime(DestFile,FileTime);
      Close(DestFile);
      ERASE(SrcFile);
      RENAME(DestFile,FName);
    END
  ELSE
    Writeln('File error with file ',DFName);
END;

PROCEDURE ModifyStamp(FoundPos: Integer; FileTime: LongInt);

VAR
  I: Integer;

BEGIN
  Writeln(' Modifying Stamp ',FoundPos);
  Seek(ByteFile,FoundPos-1);
  FOR I:=1 TO Length(StampLine) DO
    Write(ByteFile,BYTE(StampLine[I]));
  Close(ByteFile);
  Reset(ByteFile);
  SetFTime(ByteFile,FileTime);
END;

PROCEDURE ProcessThisFile(FileInfo:SearchRec);

VAR
  DT:DateTime;
  B: Byte;
  I,FoundPos: Integer;

BEGIN
  WITH FileInfo DO BEGIN
    Write(CurrentPath);
    Write(FixString(Name,12),' ');
    UnpackTime(Time,DT);
    StampLine:=FileTimeString(DT) + ' ' + FileDateString(DT);
    Write(StampLine);
    StampLine:='(*| ' + StampLine + ' *)';
    Assign(ByteFile,Name);
    Reset(ByteFile);
    TextLine:='';
    I:=0;
    REPEAT
      Read(ByteFile,B);
      INC(I);
      IF B <> $0D THEN
        TextLine:=TextLine+CHR(B);
    UNTIL B = $0D;
    FoundPos:=POS('(*|',TextLine);
    IF FoundPos=0 THEN
      BEGIN
        Close(ByteFile);
        AddStamp(Name);
      END
    ELSE BEGIN
      IF POS(StampLine,TextLine) = 0 THEN
        ModifyStamp(FoundPos,Time)
      ELSE
        Writeln;
      Close(ByteFile);
    END;
(*  Writeln(TextLine,' ',I-1,' ',Length(TextLine));
    Writeln;*)
  END;
END;

BEGIN
  Writeln('File Date Stamp Program by B Whitnall, V1.5');
  OptionString:='';
  FileSpec:='*.PAS';
  Prefix:='';
  Suffix:='';
  IF ParamCount > 0 THEN FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN
        FileSpec:=TextLine;
      IF I = 2 THEN
        Prefix:=TextLine;
      IF I = 3 THEN
        Suffix:=TextLine;
    END;
  END;
  IF FileSpec = '?' THEN ShowHelp;
  I:=POS(':',FileSpec);
  IF I = 0 THEN
    BEGIN
      ChosenDrive:='';
      DriveNum:=0;
    END
  ELSE BEGIN
    ChosenDrive:=COPY(FileSpec,1,I);
    DriveNum:=ORD(UpCase(ChosenDrive[1]))-$40;
    IF Length(FileSpec) = I THEN
      FileSpec:=FileSpec+'*.PAS';
  END;
(*  IF POS(':',FileSpec) > 0 THEN BEGIN
    Writeln('Warning - Drive specification not supported.');
    HALT;
  END;*)
  IF POS('\',FileSpec) > 0 THEN BEGIN
    Writeln('Warning - Path specification not supported.');
    HALT;
  END;
  I:=POS('.',FileSpec);
  IF I = 0 THEN
    BEGIN
      Writeln('Warning - No File Extension specified.');
      HALT;
    END
  ELSE
    FileExt:=COPY(FileSpec,I+1,3);
  IF Prefix = '' THEN BEGIN
    IF FileExt='ASM' THEN
      Prefix:='; ';
    IF ((FileExt='C') OR (FileExt='CPP')) THEN BEGIN
      Prefix:='/* ';
      Suffix:=' */';
    END;
  END;
  ProcessOptions;
  GetDir(0,OriginalPath);
  ChDir(ChosenDrive);
  GetDir(DriveNum,CurrentPath);
  IF CurrentPath[Length(CurrentPath)] <> '\' THEN
    CurrentPath:=CurrentPath+'\';
  FindFirst(FileSpec,Archive,FindRec);
  WHILE DosError=0 DO BEGIN
    ProcessThisFile(FindRec);
    FindNext(FindRec);
  END;
  ChDir(OriginalPath);
END.
